@extends('laravelinstaller::layouts.master')

@section('template_title')
    {{ __('Step 1 | Server Requirements') }}
@endsection

@section('title')
    <i class="fa fa-list-ul fa-fw" aria-hidden="true"></i>
    {{ __('Server Requirements') }}
@endsection

@section('container')
    @foreach ($requirements['requirements'] as $type => $requirement)
        <ul class="list">
            @if ($type == 'php')
                <li class="list__item list__title {{ $phpSupportInfo['supported'] ? 'success' : 'error' }}">
            @endif
            @if ($type == 'ioncube')
                <li class="list__item list__title {{ $ioncubeSupportInfo['supported'] ? 'success' : 'error' }}">
            @endif
            @if ($type == 'apache')
                <li class="list__item list__title">
            @endif
            <strong>{{ ucfirst($type) }}</strong>
            @if ($type == 'php')
                <strong>
                    <small>
                        {{ __('(version') }} {{ $phpSupportInfo['minimum'] }} {{ __('required)') }}
                    </small>
                </strong>
                <span class="float-right">
                    <strong>
                        {{ $phpSupportInfo['current'] }}
                    </strong>
                    <i class="fa fa-fw fa-{{ $phpSupportInfo['supported'] ? 'check-circle-o' : 'exclamation-circle' }} row-icon"
                        aria-hidden="true"></i>
                </span>
            @endif

            @if ($type == 'ioncube')
                <strong>
                    <small>
                        {{ __('(version') }} {{ $ioncubeSupportInfo['minimum'] }} {{ __('required)') }}
                    </small>
                </strong>
                <span class="float-right">
                    <strong>
                        {{ $ioncubeSupportInfo['current'] }}
                    </strong>
                    <i class="fa fa-fw fa-{{ $ioncubeSupportInfo['supported'] ? 'check-circle-o' : 'exclamation-circle' }} row-icon"
                        aria-hidden="true"></i>
                </span>
            @endif
            </li>
            @foreach ($requirements['requirements'][$type] as $extention => $enabled)
                <li class="list__item {{ $enabled ? 'success' : 'error' }}">
                    {{ $extention }}
                    <i class="fa fa-fw fa-{{ $enabled ? 'check-circle-o' : 'exclamation-circle' }} row-icon"
                        aria-hidden="true"></i>
                </li>
            @endforeach
        </ul>
    @endforeach


    @if (!isset($requirements['errors']) && $phpSupportInfo['supported'] && $ioncubeSupportInfo['supported'])
        <div class="buttons">
            <a class="button" href="{{ route('LaravelInstaller::permissions') }}">
                {{ __('Check Permissions') }}
                <i class="fa fa-angle-right fa-fw" aria-hidden="true"></i>
            </a>
        </div>
    @endif
@endsection
