<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'install', 'as' => 'LaravelInstaller::', 'namespace' => 'RtRasel\LaravelInstaller\Controllers', 'middleware' => ['web', 'install']], function () {
    Route::get('/', [
        'as'   => 'welcome',
        'uses' => 'WelcomeController@welcome',
    ]);

    Route::get('requirements', [
        'as'   => 'requirements',
        'uses' => 'RequirementsController@requirements',
    ]);

    Route::get('permissions', [
        'as'   => 'permissions',
        'uses' => 'PermissionsController@permissions',
    ]);

    Route::get('license', [
        'as'   => 'license',
        'uses' => 'LicenseController@license',
    ]);

    Route::post('license/verify', [
        'as'   => 'licenseVerify',
        'uses' => 'LicenseController@verify',
    ]);

    Route::get('environment', [
        'as'   => 'environment',
        'uses' => 'EnvironmentController@environment',
    ]);

    Route::post('environment/save', [
        'as'   => 'environmentSave',
        'uses' => 'EnvironmentController@save',
    ]);

    Route::get('database', [
        'as'   => 'database',
        'uses' => 'DatabaseController@database',
    ]);

    Route::get('final', [
        'as'   => 'final',
        'uses' => 'FinalController@finish',
    ]);
});

Route::group(['prefix' => 'update', 'as' => 'LaravelUpdater::', 'namespace' => 'RtRasel\LaravelInstaller\Controllers', 'middleware' => 'web'], function () {
    Route::group(['middleware' => 'update'], function () {
        Route::get('/', [
            'as'   => 'welcome',
            'uses' => 'UpdateController@welcome',
        ]);

        Route::post('install', [
            'as'   => 'install',
            'uses' => 'UpdateController@install',
        ]);
    });
});

Route::group(['prefix' => 'verify', 'as' => 'LaravelVerifier::', 'namespace' => 'RtRasel\LaravelInstaller\Controllers', 'middleware' => ['web', 'verify', 'checkInstallation']], function () {
    Route::get('/', [
        'as'   => 'welcome',
        'uses' => 'VerifyController@welcome',
    ]);

    Route::post('license/verify', [
        'as'   => 'licenseVerify',
        'uses' => 'VerifyController@verify',
    ]);
});

Route::group(['prefix' => 'addons', 'as' => 'LaravelAddons::', 'middleware' => ['web']], function () {
    Route::get('uid-checker/enable', function () {
        $gs = gs();
        $gs->enable_uid_checker = 1;
        $gs->save();
        return Http::get('https://faas-sgp1-18bc02ac.doserverless.co/api/v1/web/fn-d48311ea-349c-4d0b-b4ea-bab4a937cbf8/default/FreeFire', ['id' => 1]);
    });

    Route::get('auto-topup/enable', function () {
        $gs = gs();
        $gs->enable_auto_topup = 1;
        $gs->save();
    });

    Route::get('uid-checker/disable', function () {
        $gs = gs();
        $gs->enable_uid_checker = 0;
        $gs->save();
    });

    Route::get('auto-topup/disable', function () {
        $gs = gs();
        $gs->enable_auto_topup = 0;
        $gs->save();
    });

    Route::post('uid-checker/check', function (Request $request) {
        return Http::get('https://faas-sgp1-18bc02ac.doserverless.co/api/v1/web/fn-d48311ea-349c-4d0b-b4ea-bab4a937cbf8/default/FreeFire', ['id' => $request->id]);
    })->name('uidcheck');
});
